#include <LiquidCrystal_I2C.h>
#include <Wire.h>

#define schreiben
#define EEPROM1 0x57

byte zahl;

LiquidCrystal_I2C lcd(0x27,2,1,0,4,5,6,7,3,POSITIVE);

void setup() 
{
  lcd.begin(20,4);
  Wire.begin();
  #ifdef schreiben
    eeprom_write(EEPROM1,0,200); // Schreibe den Wert 120
  #endif
  zahl=eeprom_read(EEPROM1,0);
  lcd.print(zahl);
}

void loop() {}

byte eeprom_read(byte i2c, unsigned int adresse)
{
  byte data=0xFF;
  Wire.beginTransmission(i2c); // Adresse das EEPROMs
  Wire.write((unsigned int)(adresse >> 8));
  Wire.write((unsigned int)(adresse & 0xFF));
  Wire.endTransmission();
  Wire.requestFrom(i2c,1);
  if (Wire.available()) data=Wire.read();
  return data;
}

void eeprom_write(byte i2c, unsigned int adresse, byte data)
{
  Wire.beginTransmission(i2c);
  Wire.write((unsigned int)(adresse >> 8));
  Wire.write((unsigned int)(adresse & 0xFF));
  Wire.write(data);
  Wire.endTransmission();
  delay(5); // Schreiben benötigt Zeit
}

